<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        //
        $table_exist = Schema::connection('mysql_common')->hasTable('rvw_client_functionality_status');
        if (!$table_exist) {
            Schema::connection('mysql_common')->create('rvw_client_functionality_status', function (Blueprint $table) {
                $table->id('cfst_id');
                $table->bigInteger('cfst_cls_id', false, true)->nullable();
                $table->bigInteger('cfst_cfty_id', false, true)->nullable();
                $table->bigInteger('cfst_clu_id', false, true)->nullable();
                $table->char('cfst_status', 1);
                $table->unsignedBigInteger('cfst_posted_by');
                $table->dateTime('cfst_posted_date');
                $table->unsignedBigInteger('cfst_proxy_id')->nullable();
                $table->char('cfst_operation', 1);
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
