<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $table_exist = Schema::connection('mysql_common')->hasTable('rvw_client_url');
        if (!$table_exist) {
            Schema::connection('mysql_common')->create('rvw_client_url', function (Blueprint $table) {
                $table->id('clu_id');
                $table->integer('clu_acls_id', false, true)->comment('pk of rvw_all_clients');
                $table->string('clu_url', 250);
                $table->char('clu_status', 1);
                $table->unsignedBigInteger('clu_posted_by');
                $table->dateTime('clu_posted_date');
                $table->unsignedBigInteger('clu_proxy_id')->nullable();
                $table->char('clu_operation', 1);
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
