<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('rvw_research_integrity_reports', function (Blueprint $table) {
            Schema::table('rvw_research_integrity_reports', function (Blueprint $table) {
                $table->unsignedBigInteger('rri_atmnt_id')
                      ->nullable()
                      ->comment('article attachment which is used to generate rvri report')
                      ->after('rri_new_report');
            });
        });
        Schema::table('tbk_research_integrity_reports', function (Blueprint $table) {
            Schema::table('tbk_research_integrity_reports', function (Blueprint $table) {
                $table->unsignedBigInteger('rri_atmnt_id')
                      ->nullable()
                      ->comment('article attachment which is used to generate rvri report')
                      ->after('rri_new_report');
            });
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('rvw_research_integrity_reports', function (Blueprint $table) {
            Schema::dropColumn('rri_atmnt_id');
        });

        Schema::table('tbk_research_integrity_reports', function (Blueprint $table) {
            Schema::dropColumn('rri_atmnt_id');
        });
    }
};
