<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try {
            /* 
                *** creating main table rvw_report_v3 and its backup table tbk_report_v3
            */
            if (!Schema::hasTable('rvw_reports_v3')) {
                Schema::create('rvw_reports_v3', function (Blueprint $table) {
                    $table->bigIncrements('rep_id');
                    $table->json('rep_fields')->nullable();
                    $table->mediumText('rep_title');
                    $table->string('rep_type', 21);
                    $table->string('rep_col_value')->nullable();
                    $table->longText('rep_field_function');
                    $table->longText('rep_values_seperator');
                    $table->string('rep_ratio_base_filter', 64)->nullable();
                    $table->json('rep_filter')->nullable();
                    $table->string('rep_show_total_type', 64)->nullable();
                    $table->unsignedBigInteger('rep_parent')->nullable();
                    $table->unsignedBigInteger('rep_rfld_id')->nullable()->comment('FK of rvw_report_folders_v3');
                    $table->char('rep_locked', 1)->default('n');
                    $table->integer('rep_field_order')->nullable();
                    $table->char('rep_column_order', 1)->comment('a=asc,d=desc');
                    $table->bigInteger('rep_posted_by');
                    $table->dateTime('rep_posted_date');
                    $table->bigInteger('rep_proxy_id')->nullable();
                    $table->char('rep_operation', 1)->default('u')->comment('u-update,i-insert');
                    /* Following columns are Deprecated in latest ReView report version
                        $table->json('rep_filter_old')->nullable();
                        $table->char('rep_live_preview', 1)->default('n');
                        $table->string('rep_export_settings', 50);
                    */
                });
            }
            if (!Schema::hasTable('tbk_reports_v3')) {
                Schema::create('tbk_reports_v3', function (Blueprint $table) {
                    $table->bigInteger('rep_id');
                    $table->json('rep_fields')->nullable();
                    $table->mediumText('rep_title');
                    $table->string('rep_type', 21);
                    $table->string('rep_col_value')->nullable();
                    $table->longText('rep_field_function');
                    $table->longText('rep_values_seperator');
                    $table->string('rep_ratio_base_filter', 64)->nullable();
                    $table->json('rep_filter')->nullable();
                    $table->string('rep_show_total_type', 64)->nullable();
                    $table->unsignedBigInteger('rep_parent')->nullable();
                    $table->unsignedBigInteger('rep_rfld_id')->nullable()->comment('FK of rvw_report_folders_v3');
                    $table->char('rep_locked', 1)->default('n');
                    $table->integer('rep_field_order')->nullable();
                    $table->char('rep_column_order', 1)->comment('a=asc,d=desc');
                    $table->bigInteger('rep_posted_by');
                    $table->dateTime('rep_posted_date');
                    $table->bigInteger('rep_proxy_id')->nullable();
                    $table->char('rep_operation', 1)->default('u')->comment('u-update,i-insert');
                    $table->bigIncrements('tbk_id');
                    /* Following columns are Deprecated in latest ReView report version
                        $table->json('rep_filter_old')->nullable();
                        $table->char('rep_live_preview', 1)->default('n');
                        $table->string('rep_export_settings', 50);
                    */
                });
            }

            /* 
                *** creating main table rvw_report_email_v3 and its backup table tbk_report_v3
                *** creating insert and update triggers for rvw_report_email_v3
            */
            if (!Schema::hasTable('rvw_report_email_v3')) {
                Schema::create('rvw_report_email_v3', function (Blueprint $table) {
                    $table->bigIncrements('rmil_id');
                    $table->unsignedBigInteger('rmil_rep_id')->comment('pk of rvw_reports_v3');
                    $table->string('rmil_send_to', 100);
                    $table->string('rmil_send_cc', 100)->nullable();
                    $table->char('rmil_report_format', 1)->default('p')->comment('p-pdf,c-csv');
                    $table->char('rmil_report_period', 1)->default('w')->comment('d-daily,w-weekly,m-monthly');
                    $table->dateTime('rmil_report_start');
                    $table->mediumText('rmil_covering_letter')->nullable();
                    $table->dateTime('rmil_report_last_sent')->nullable();
                    $table->dateTime('rmil_posted_date');
                    $table->unsignedBigInteger('rmil_posted_by')->nullable();
                    $table->unsignedBigInteger('rmil_proxy_id')->nullable();
                    $table->char('rmil_operation', 1)->default('u')->comment('u-update,i-insert');
                    $table->foreign('rmil_rep_id')->references('rep_id')->on('rvw_reports_v3');
                });
            }
            DB::unprepared("
            DROP TRIGGER IF EXISTS trg_reports_after_insert_v3;
            CREATE TRIGGER trg_reports_email_after_insert_v3
            AFTER INSERT ON rvw_report_email_v3
            FOR EACH ROW
            INSERT INTO tbk_report_email_v3
            SELECT *, NULL AS tbk_id
            FROM rvw_report_email_v3
            WHERE rmil_id = NEW.rmil_id;
        ");
            DB::unprepared("
            DROP TRIGGER IF EXISTS trg_reports_after_update_v3;
            CREATE TRIGGER trg_reports_email_after_update_v3
            AFTER UPDATE ON rvw_report_email_v3
            FOR EACH ROW
            BEGIN
                IF (NEW.rmil_operation != 'm') THEN
                    INSERT INTO tbk_report_email_v3
                    SELECT *, NULL AS tbk_id
                    FROM rvw_report_email_v3
                    WHERE rmil_id = OLD.rmil_id;
                END IF;
            END;
        ");
            if (!Schema::hasTable('tbk_report_email_v3')) {
                Schema::create('tbk_report_email_v3', function (Blueprint $table) {
                    $table->bigInteger('rmil_id');
                    $table->unsignedBigInteger('rmil_rep_id')->comment('pk of rvw_reports_v3');
                    $table->string('rmil_send_to', 100);
                    $table->string('rmil_send_cc', 100)->nullable();
                    $table->char('rmil_report_format', 1)->default('p')->comment('p-pdf,c-csv');
                    $table->char('rmil_report_period', 1)->default('w')->comment('d-daily,w-weekly,m-monthly');
                    $table->dateTime('rmil_report_start');
                    $table->mediumText('rmil_covering_letter')->nullable();
                    $table->dateTime('rmil_report_last_sent')->nullable();
                    $table->dateTime('rmil_posted_date');
                    $table->unsignedBigInteger('rmil_posted_by')->nullable();
                    $table->unsignedBigInteger('rmil_proxy_id')->nullable();
                    $table->char('rmil_operation', 1)->default('u')->comment('u-update,i-insert');
                    $table->bigIncrements('tbk_id');
                });
            }

            /* 
                *** creating main table rvw_report_email_sent_log_v3
            */
            if (!Schema::hasTable('rvw_report_email_sent_log_v3')) {
                Schema::create('rvw_report_email_sent_log_v3', function (Blueprint $table) {
                    $table->bigIncrements('resl_id');
                    $table->unsignedBigInteger('resl_rep_id')->comment('pk of rvw_reports_v3');
                    $table->unsignedBigInteger('resl_esl_id')->comment('pk of rvw_email_send_log');
                    $table->char('resl_rmil_report_period', 1);
                    $table->unsignedBigInteger('resl_posted_by');
                    $table->dateTime('resl_posted_date');
                    $table->unsignedBigInteger('resl_proxy_id')->default(0);
                    $table->char('resl_operation', 1);
                    $table->foreign('resl_rep_id')->references('rep_id')->on('rvw_reports_v3');
                });
            }

            /* 
                *** creating main table rvw_report_folders_v3 and its backup table tbk_report_folders_v3
                *** creating insert and update triggers for rvw_report_folders_v3
            */
            if (!Schema::hasTable('rvw_report_folders_v3')) {
                Schema::create('rvw_report_folders_v3', function (Blueprint $table) {
                    $table->bigIncrements('rfld_id');
                    $table->bigInteger('rfld_parent_id')->nullable()->comment('self reference');
                    $table->string('rfld_title');
                    $table->bigInteger('rfld_posted_by')->nullable();
                    $table->dateTime('rfld_posted_date');
                    $table->bigInteger('rfld_proxy_id')->nullable();
                    $table->char('rfld_operation', 1)->default('u');
                });
            }
            DB::unprepared("
                DROP TRIGGER IF EXISTS trg_report_folders_after_insert_v3;
                CREATE TRIGGER trg_report_folders_after_insert_v3 
                AFTER INSERT ON rvw_report_folders_v3
                FOR EACH ROW 
                BEGIN
                    INSERT INTO tbk_report_folders_v3 
                    SELECT *, NULL AS tbk_id 
                    FROM rvw_report_folders_v3 
                    WHERE rfld_id = NEW.rfld_id;
                END
            ");
            DB::unprepared("
                DROP TRIGGER IF EXISTS trg_report_folders_after_update_v3;
                CREATE TRIGGER trg_report_folders_after_update_v3 
                AFTER UPDATE ON rvw_report_folders_v3 
                FOR EACH ROW 
                BEGIN
                    IF (NEW.rfld_operation != 'm') THEN
                        INSERT INTO tbk_report_folders_v3
                        SELECT *, NULL AS tbk_id 
                        FROM rvw_report_folders_v3
                        WHERE rfld_id = OLD.rfld_id;
                    END IF;
                END
            ");
            if (!Schema::hasTable('tbk_report_folders_v3')) {
                Schema::create('tbk_report_folders_v3', function (Blueprint $table) {
                    $table->bigInteger('rfld_id');
                    $table->bigInteger('rfld_parent_id')->nullable()->comment('self reference');
                    $table->string('rfld_title');
                    $table->bigInteger('rfld_posted_by')->nullable();
                    $table->dateTime('rfld_posted_date');
                    $table->bigInteger('rfld_proxy_id')->nullable();
                    $table->char('rfld_operation', 1)->default('u');
                    $table->bigIncrements('tbk_id');
                });
            }

            DB::table('rvw_general_permissions')->updateOrInsert(['permission_route' => 'manage-reports'], [
                'permission_route' => 'manage-reports',
                'permission_parent_route' => 'manage-reports',
                'permission_caption' => 'Manage Reports',
                'permission_icon' => 'tasks',
                'permission_roles' => json_encode(["super_admin"]),
                'permission_posted_by' => '1',
                'permission_posted_date' => now(),
                'permission_proxy_id' => '1',
                'permission_operation' => 'i'
            ]);
            /* RUN IF NEEDED */
            // DB::table('rvw_general_permissions')->where('permission_route', 'view-report')->delete();

            /* *** creating insert and update triggers for rvw_report_v3 */
            // Create AFTER INSERT trigger if it doesn't exist
            DB::unprepared("
                DROP TRIGGER IF EXISTS trg_reports_after_insert_v3;
                CREATE TRIGGER trg_reports_after_insert_v3
                AFTER INSERT ON rvw_reports_v3
                FOR EACH ROW
                INSERT INTO tbk_reports_v3
                SELECT *, NULL AS tbk_id
                FROM rvw_reports_v3
                WHERE rep_id = NEW.rep_id;
            ");
            // Create AFTER UPDATE trigger if it doesn't exist
            DB::unprepared("
                DROP TRIGGER IF EXISTS trg_reports_after_update_v3;
                CREATE TRIGGER trg_reports_after_update_v3
                AFTER UPDATE ON rvw_reports_v3
                FOR EACH ROW
                BEGIN
                    IF (NEW.rep_operation != 'm') THEN
                        INSERT INTO tbk_reports_v3
                        SELECT *, NULL AS tbk_id
                        FROM rvw_reports_v3
                        WHERE rep_id = OLD.rep_id;
                    END IF;
                END;
            ");

        } catch (\Throwable $e) {
            // Clean up
            $this->down();
            // Re-throw the error so Laravel marks the migration as failed
            throw $e;
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbk_report_email_sent_log_v3');
        Schema::dropIfExists('rvw_report_email_sent_log_v3');
        Schema::dropIfExists('rvw_report_folders_v3');
        Schema::dropIfExists('tbk_report_folders_v3');
        Schema::dropIfExists('rvw_report_email_v3');
        Schema::dropIfExists('tbk_report_email_v3');
        Schema::dropIfExists('rvw_reports_v3');
        Schema::dropIfExists('tbk_reports_v3');
    }
};
