<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if(!Schema::hasColumn('rvw_article_pdf','pdf_ith_action_stage_id'))
        {
            Schema::table('rvw_article_pdf',function(Blueprint $table){
                $table->bigInteger('pdf_ith_action_stage_id')
                ->nullable()->unsigned()->index()
                ->after('pdf_ith_document_id')
                ->comment('pk of rvw_article_flow');
            });
        }

        if(!Schema::hasColumn('tbk_article_pdf','pdf_ith_action_stage_id'))
        {
            Schema::table('tbk_article_pdf',function(Blueprint $table){
                $table->bigInteger('pdf_ith_action_stage_id')
                ->nullable()->unsigned()->index()
                ->after('pdf_ith_document_id')
                ->comment('pk of rvw_article_flow');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if(Schema::hasColumn('rvw_article_pdf','pdf_ith_action_stage_id'))
        {
            Schema::table('rvw_article_pdf',function(Blueprint $table){
                $table->dropColumn('pdf_ith_action_stage_id');
            });
        }

        if(Schema::hasColumn('tbk_article_pdf','pdf_ith_action_stage_id'))
        {
            Schema::table('tbk_article_pdf',function(Blueprint $table){
                $table->dropColumn('pdf_ith_action_stage_id');
            });
        }
    }
};
