<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('rvw_research_integrity_reports', 'rri_submission_type')) {

           Schema::table('rvw_research_integrity_reports', function (Blueprint $table) {
            $table->char('rri_submission_type', 1)
                  ->default('a')
                  ->comment('a - auto generated, m - manually generated')
                  ->after('rri_atmnt_id');
            });
        }

        if (!Schema::hasColumn('tbk_research_integrity_reports', 'rri_submission_type')) {
            Schema::table('tbk_research_integrity_reports', function (Blueprint $table) {
                $table->char('rri_submission_type', 1)
                    ->default('a')
                    ->comment('a - auto generated, m - manually generated')
                    ->after('rri_atmnt_id');
                });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        
        Schema::table('rvw_research_integrity_reports', function (Blueprint $table) {
            $table->dropColumn('rri_submission_type');
        });

        Schema::table('tbk_research_integrity_reports', function (Blueprint $table) {
            $table->dropColumn('rri_submission_type');
        });
    }
};
