<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('rvw_journal_workflows', 'jwf_enable_confirm_from_editor')) {

           Schema::table('rvw_journal_workflows', function (Blueprint $table) {
           $table->char('jwf_enable_confirm_from_editor', 1)
                    ->default('n')
                    ->collation('utf8mb4_unicode_ci')
                    ->comment('y - need confirmation from editor for stage completion, n - didnot need confirmation')
                    ->after('jwf_enable_transfer');
            });
        }
        if (!Schema::hasColumn('tbk_journal_workflows', 'jwf_enable_confirm_from_editor')) {
            Schema::table('tbk_journal_workflows', function (Blueprint $table) {
                $table->char('jwf_enable_confirm_from_editor', 1)
                    ->default('n')
                    ->collation('utf8mb4_unicode_ci')
                    ->comment('y - need confirmation from editor for stage completion, n - didnot need confirmation')
                    ->after('jwf_enable_transfer');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('rvw_journal_workflows', function (Blueprint $table) {
            $table->dropColumn('jwf_enable_confirm_from_editor');
        });

        Schema::table('tbk_journal_workflows', function (Blueprint $table) {
            $table->dropColumn('jwf_enable_confirm_from_editor');
        });
    }
};