<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
          if (!Schema::hasColumn('rvw_review_rating', 'rvr_feedback')) {
        Schema::table('rvw_review_rating', function (Blueprint $table) {
            $table->mediumText('rvr_feedback')
                ->nullable()
                ->comment('rating feedback from privileged user')
                ->after('rvr_rating');
        });
    }

    if (!Schema::hasColumn('tbk_review_rating', 'rvr_feedback')) {
        Schema::table('tbk_review_rating', function (Blueprint $table) {
            $table->mediumText('rvr_feedback')
                ->nullable()
                ->comment('rating feedback from privileged user')
                ->after('rvr_rating');
        });
    }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
      Schema::table('rvw_review_rating', function (Blueprint $table) {
            $table->dropColumn('rvr_feedback');
        });;
             Schema::table('tbk_review_rating', function (Blueprint $table) {
            $table->dropColumn('rvr_feedback');
        });
    }
};
