<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try {
                if (Schema::hasColumn('rvw_journals', 'jnl_journal_code')) 
                {
                    DB::statement("ALTER TABLE rvw_journals MODIFY jnl_journal_code VARCHAR(100)");
                }
                if (Schema::hasColumn('tbk_journals', 'jnl_journal_code')) {
                    DB::statement("ALTER TABLE tbk_journals MODIFY jnl_journal_code VARCHAR(100)");

                }
            } catch (\Exception $e) {
                 DB::rollback();
            }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
         try {
            if (Schema::hasColumn('rvw_journals', 'jnl_journal_code')) 
            {
                DB::statement("ALTER TABLE rvw_journals MODIFY jnl_journal_code VARCHAR(30)");
            }

            if (Schema::hasColumn('tbk_journals', 'jnl_journal_code')) 
            {
                DB::statement("ALTER TABLE tbk_journals MODIFY jnl_journal_code VARCHAR(30)");
            }
        } catch (\Exception $e) {
             DB::rollback();
        }
    }
};
