<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try {
            DB::statement("CREATE TABLE `rvw_article_order_details_log` (`aod_id` BIGINT NOT NULL AUTO_INCREMENT, 
            `aod_ord_id` BIGINT UNSIGNED NOT NULL, 
            `aod_art_id` BIGINT UNSIGNED NOT NULL,
            `aod_art_old_artcode` VARCHAR(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
            `aod_art_new_artcode` VARCHAR(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
            `aod_art_old_order` BIGINT UNSIGNED NOT NULL, 
            `aod_art_new_order` BIGINT UNSIGNED NOT NULL,
            `aod_posted_by` BIGINT NULL , 
            `aod_posted_date` DATETIME NULL ,
            `aod_proxy_id` BIGINT NOT NULL, 
            `aod_operation` CHAR(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT 'u' COMMENT ' u-update,i-insert ' , 
            PRIMARY KEY (`aod_id`))  ENGINE = InnoDB; ");
            DB::statement("ALTER TABLE `rvw_article_order_details_log` ADD INDEX(`aod_ord_id`);");
            DB::statement("ALTER TABLE `rvw_article_order_details_log` ADD INDEX(`aod_art_id`);");
        } catch (\Exception $e) {
            DB::rollback();
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
         //
    }
};
