<?php

/*$config['credit']['status'] = array(
	'eq' =>'Equal',
	'sp' =>'Supporting',
	'ld' =>'Lead',
);*/
$config['review_flow'] = array(
	'author_submission' => array(
		'label' => 'Author Submission',
		'assignment_tabs' => true,//only for article assignment
		'internal_statges' => array(
			'author_submission' => 'Author Submission'
		),
		'roles' => array(
			'author'),
		'child_stages' => array(
			'staff_check',
			'pre_assessment',
			'authors_declaration'),
		'email_templates' => array(
		),
		'possible_email_tmpl_actions' => array(
			'completed' => 'On complete',
			'assigned_not_accepted' => 'Reminder to accept',
			'accepted_not_completed' => 'Reminder to complete',
			'rescind_destination' => 'On rescind(destination stage)',
			'manual_reminder'=>'Manual reminder',
			'assigned' => 'On assignment/invitation',
			'uninvite_user' => 'Uninvite user',
			'accepted' => 'On accept',
			'declined' => 'On decline',

		),
		'multiple_child' => false, // flag to set the stage allow multiple childs or not
		'more_reviewers' => false,
		'stage_for' => 'review',
	),
	'transit' => array(
		'label' => 'Transit',
		'assignment_tabs' => true,//only for article assignment
		'internal_statges' => array(
			'transit' => 'Transit'
		),
		'roles' => array(
			'author'),
		'static_forms' => array(
			'transfer_suggestions'
		),
		'generic_form' => -1, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.' Changed 0 to -1 . Transit stage don't need custom forms
		'child_stages' => array(),
		'email_templates' => array(
		),
		'possible_email_tmpl_actions' => array(
			'completed' => 'On complete',
			'accepted_not_completed' => 'Reminder to complete',
			'manual_reminder'=>'Manual reminder',
			),
		'multiple_child' => false, // flag to set the stage allow multiple childs or not
		'enable_casrai_credits_confirm' => false,
		'enable_orcid_confirm' => false,
		'more_reviewers' => false,
		'stage_for' => 'review',
	),
	'authors_declaration' => array(
		'label' => 'Authors Declaration',
		'assignment_tabs' => true,//only for article assignment
		'internal_statges' => array(
			'authors_declaration' => 'Authors Declaration'
		),
		'roles' => array(
			'author'),
		'child_stages' => array(
			'staff_check',
			'pre_assessment'),
		'email_templates' => array(
//				'article_tags',
//				'author_tags'
		),
		'possible_email_tmpl_actions' => array(
			'assigned' => 'On stage initialization',
			'completed' => 'On complete',
			'rescind_source' => 'On rescind(source stage)',
			'rescind_destination' => 'On rescind(destination stage)',
			'reset' => 'On Reset',
			'accepted_not_completed' => 'Reminder to complete',
			'manual_reminder'=>'Manual reminder',
			),
		'disable_criteria' => array(),
		'multiple_child' => false, // flag to set the stage allow multiple childs or not
		//If disable criteria is empty this stage can be disabled without any check.
		'permission' => array(
			'rescind',
			'reset',
		),
		'multiple_stages' => TRUE,
		'enable_casrai_credits_confirm' => false,
		'enable_orcid_confirm' => false,
		'more_reviewers' => false,
		'stage_for' => 'review',
	),
	'staff_check' => array(
		'export_to_gigadb'=>TRUE,
		'connect_to_es' => TRUE,//es = EditorSute
		'label' => 'Staff Check',
		'assignment_tabs' => true,//only for article assignment
		'internal_statges' => array(
			'ready_for_staff_check' => 'Ready for %stage_name%',
			'staff_check_in_progress' => '%stage_name% in Progress'
		),
		'roles' => array(
			'staff',
			'associate_editor',
			'editor_in_chief'
		),
		'child_stages' => array(
			'review',
			'pre_assessment',
			'post_assessment',
			'revision',
			'reject')
		,
		'email_templates' => array(
//					'article_tags',
//					'author_tags',
		),
		'possible_email_tmpl_actions' => array(
			'initialization' => 'On stage initialization',
			'assigned' => 'On assignment/invitation',
			'unassign_user' => 'Unassign user',
			//'uninvite_user' => 'Uninvite user',
			'completed' => 'On complete',
			'rescind_source' => 'On rescind(source stage)',
			'rescind_destination' => 'On rescind(destination stage)',
			'reset' => 'On Reset',
			'accepted_not_completed' => 'Reminder to complete',
			'manual_reminder'=>'Manual reminder',
			),
		'possible_email_tmpl_additional_recipient' => array(),
		'multiple_child' => true, 
		'disable_criteria' => array(
			'before' => array(),
			'after' => array(
				'pre_assessment',
				'post_assessment'
			),
			'and' => TRUE
		),
		'permission' => array(
			'rescind',
			'reset',
			'transfer',
			//'duplicate_check'
		),
		'enable_ithenticate' => TRUE,
//			'comments_to_author' => true
		'enable_casrai_credits_confirm' => false,
		'enable_orcid_confirm' => false,
		'more_reviewers' => false,
		'stage_for' => 'review',
	),
	'pre_assessment' => array(
		'label' => 'Pre-review Assessment',
		'internal_statges' => array(
			'ready_for_pre_assessment' => 'Ready for %stage_name%',
			'pre_assessment_in_progress' => '%stage_name% in Progress'
		),
		'roles' => array(
			'associate_editor',
			'editor_in_chief',
			'staff'),
		'child_stages' => array(
			'pre_assessment',
			'review',
			'post_assessment',
			'revision',
			'reject',
			'staff_check'),
		'email_templates' => array(
//					'article_tags',
//					'author_tags',
//				'transfer_article_tags',
		),
		'possible_email_tmpl_actions' => array(
			'initialization' => 'On stage initialization',
			'assigned' => 'On assignment/invitation',
			'accepted' => 'On accept',
			'declined' => 'On decline',
			'completed' => 'On complete',
			'rescind_source' => 'On rescind(source stage)',
			'rescind_destination' => 'On rescind(destination stage)',
			'reset' => 'On reset',
			'unassign_user' => 'Unassign user',
			'uninvite_user' => 'Uninvite user',
			'assigned_not_accepted' => 'Reminder to accept',
			'accepted_not_completed' => 'Reminder to complete',
			'manual_reminder'=>'Manual reminder',
			),
		'possible_email_tmpl_additional_recipient' => array(),
		'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
		'multiple_child' => true, 
		'default_assignment_type' => 'self_service',
		'assignment_options' => array(
			'self_service',
			//'invitation',
			'manual'),
		'disable_criteria' => array(
			'before' => array(
				'staff_check',
				'pre_assessment'
			),
			'after' => array(),
			'and' => TRUE
		),
		'permission' => array(
			'rescind',
			'reset',
			'transfer'
		),
		'assignment_tabs' => true,//only for article assignment
		'enable_ithenticate' => FALSE,
		'enable_casrai_credits_confirm' => false,
		'enable_orcid_confirm' => false,
		'more_reviewers' => false,
		'stage_for' => 'review',
//			'comments_to_author' => true
	),
	'revision' => array(
		'label' => 'Author correction',
		'internal_statges' => array(
			'revision' => 'Revision',
		),
		'roles' => array(
			'author'),
		'child_stages' => array(
			'staff_check',
			'pre_assessment',
			'post_assessment',
			'accept',
		),
		'email_templates' => array(
//					'article_tags',
//					'author_tags',
		),
		'possible_email_tmpl_actions' => array(
			'assigned' => 'On stage initialization',
			'completed' => 'On complete',
			'rescind_source' => 'On rescind(source stage)',
			'rescind_destination' => 'On rescind(destination stage)',
			'reset' => 'On reset',
			'accepted_not_completed' => 'Reminder to complete',
			'confirm_casrai' => 'Confirm Contributorship',
			'confirm_orcid' => 'Connect ORCID',
			'manual_reminder'=>'Manual reminder',
			),
		'arrow_begin_with' => 'Top',
		'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
		'multiple_child' => false, // flag to set the stage allow multiple childs or not
		'disable_criteria' => array(),
		'permission' => array(
			'rescind',
			'reset',
		),
		'assignment_tabs' => true,//only for article assignment
		'enable_casrai_credits_confirm' => false,
		'enable_orcid_confirm' => false,
		'more_reviewers' => false,
		'stage_for' => 'review',
	),
	'review' => array(
		'label' => 'Peer review Process',
		'internal_statges' => array(
			'ready_for_review' => 'Ready for %stage_name%',
			'review_in_progress' => '%stage_name% in Progress'
		),
		'roles' => array(
			'reviewer'), //assigned only reviewer role for review stage
		'child_stages' => array(
			'review',
			'post_assessment',
//				'ae_recommendation',
		),
		'email_templates' => array(
//					'article_tags',
		//	'author_tags',
//				'review_tags',
		),
		'possible_email_tmpl_actions' => array(
			'initialization' => 'On stage initialization',
			'assigned' => 'On assignment/invitation',
			'accepted' => 'On accept',
			'declined' => 'On decline',
			'completed' => 'On complete',
			'rescind_source' => 'On rescind(source stage)',
			'rescind_destination' => 'On rescind(destination stage)',
			'unassign_user' => 'Unassign user',
			'uninvite_user' => 'Uninvite user',
			'reset' => 'On Reset',
			'assigned_not_accepted' => 'Reminder to accept',
			'accepted_not_completed' => 'Reminder to complete',
			'pnd_reviewer_shortlist' => 'Reminder to shortlist reviewer', //pending
			'pnd_reviewer_invite' => 'Reminder to invite reviewer',
			'manual_reminder'=>'Manual reminder',
			'review_resubmit' => 'Review resubmit'
			),//pending
		'invite' => true,
		//default assignment is should be either invitation or manual because self_service not available for review
		'default_assignment_type' => 'invitation',
		'assignment_options' => array(
			'invitation',
			'manual'),
//			'static_forms' => array(
//				'review_summary'
//			),
		'participate_discussion_roles' => array(
			'staff',
			'associate_editor',
			'editor_in_chief'
		),
		'generic_form' => 1, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
		'multiple_child' => false, // flag to set the stage allow multiple childs or not
		'disable_criteria' => array(),
		'permission' => array(
			'rescind',
			'reset',
		),
		'assignment_tabs' => false,//only for article assignment
		'enable_casrai_credits_confirm' => false,
		'enable_orcid_confirm' => false,
		'more_reviewers' => false,
		'stage_for' => 'review',
	),
	'post_assessment' => array(
		'label' => 'Post-review assessment',
		'internal_statges' => array(
			'ready_for_post_assessment' => 'Ready for Post-review Assessment',
			'post_assessment_in_progress' => 'Post-review Assessment in Progress'
		),
		'roles' => array(
							'staff',
			'associate_editor',
			'editor_in_chief'),
		'child_stages' => array(
			'post_assessment',
			'revision',
			'accept',
			'reject',
			'decision_revision',
			'pre_assessment',
			'resubmission'),
		'email_templates' => array(
//					'article_tags',
		//	'author_tags',
//				'review_tags',
		),
		'possible_email_tmpl_actions' => array(
			'initialization' => 'On stage initialization',
			'assigned' => 'On assignment/invitation',
			'accepted' => 'On accept',
			'declined' => 'On decline',
			'completed' => 'On complete',
			'rescind_source' => 'On rescind(source stage)',
			'rescind_destination' => 'On rescind(destination stage)',
			'reset' => 'On reset',
			'repeat_stage' => 'On repeat', //repeat stage due to reopen review
			'unassign_user' => 'Unassign user',
			'uninvite_user' => 'Uninvite user',
			'assigned_not_accepted' => 'Reminder to accept',
			'accepted_not_completed' => 'Reminder to complete',
			'manual_reminder'=>'Manual reminder',
			),
		'possible_email_tmpl_additional_recipient' => array(),
		'multiple_child' => true, 
		'default_assignment_type' => 'self_service',
		'assignment_options' => array(
			'self_service',
			//'invitation',
			'manual'),
		'disable_criteria' => array(
			'before' => array(
				'post_assessment'
			),
			'after' => array(
				'post_assessment'
			),
			'and' => FALSE
		),
		'permission' => array(
			'rescind',
			'reset',
			'transfer'
		),
		'assignment_tabs' => false,//only for article assignment
		'enable_casrai_credits_confirm' => false,
		'enable_orcid_confirm' => false,
		'more_reviewers' => true,
		'stage_for' => 'review',
//			'comments_to_author' => true
	),
	'accept' => array(
		'label' => 'Decision Accept',
		'internal_statges' => array(
			'accept_for_publish' => 'Accepted for Publishing'
		),
		'roles' => array(
			'staff',
			'associate_editor',
			'editor_in_chief'),
		'child_stages' => array(
			'copyright',
							'production',
			
		),
		'email_templates' => array(
//					'article_tags',
//					'author_tags',
//				'review_tags'
		),
		'generic_form' => 0,
		'possible_email_tmpl_actions' => array(
			'initialization' => 'On stage initialization',
			'assigned' => 'On assignment/invitation',
			'unassign_user' => 'Unassign user',
			//'uninvite_user' => 'Uninvite user',
			'completed' => 'On complete',
			'rescind_source' => 'On rescind(source stage)',
			'rescind_destination' => 'On rescind(destination stage)',
			'reset' => 'On reset',
			'accepted_not_completed' => 'Reminder to complete',
			'manual_reminder'=>'Manual reminder',
			),
		'multiple_child' => true, 
		'permission' => array(
			'rescind',
			'reset',
			'notifications'
		),
		'assignment_tabs' => false,//only for article assignment
		'enable_casrai_credits_confirm' => false,
		'enable_orcid_confirm' => false,
		'more_reviewers' => false,
		'stage_for' => 'review',
	),
	'reject' => array(
		'label' => 'Decision Reject',
		'assignment_tabs' => false,//only for article assignment
		'internal_statges' => array(
			'reject' => 'Article rejected'
		),
		'roles' => array(
			'staff',
			'associate_editor',
			'editor_in_chief'),
		'child_stages' => array(),
		'email_templates' => array(
//					'article_tags',
		//	'author_tags',
//				'review_tags'
		),
		'possible_email_tmpl_actions' => array(
			'initialization' => 'On stage initialization',
			'assigned' => 'On assignment/invitation',
			'unassign_user' => 'Unassign user',
			//'uninvite_user' => 'Uninvite user',
			'declined' => 'On complete',
			'rescind_source' => 'On rescind(source stage)',
			'rescind_destination' => 'On rescind(destination stage)',
			'reset' => 'On reset',
			'manual_reminder'=>'Manual reminder',
			),
		'multiple_child' => true, 
		'permission' => array(
			'rescind',
			'reset',
			'notifications',
			'transfer'
		),
		'generic_form' => 0,
		'enable_casrai_credits_confirm' => false,
		'enable_orcid_confirm' => false,
		'more_reviewers' => false,
		'stage_for' => 'review',
	),
	'decision_revision' => array(
		'label' => 'Decision Revision',
		'internal_statges' => array(
			'decision_revision' => 'Confirm Revision'
		),
		'roles' => array(
			'staff',
			'associate_editor',
			'editor_in_chief'),
		'child_stages' => array(
			'resubmission',
			'revision'),
		'email_templates' => array(
//				'review_tags'
		),
		'possible_email_tmpl_actions' => array(
			'initialization' => 'On stage initialization',
			'assigned' => 'On assignment/invitation',
			'unassign_user' => 'Unassign user',
			//'uninvite_user' => 'Uninvite user',
			'completed' => 'On complete',
			'rescind_source' => 'On rescind(source stage)',
			'rescind_destination' => 'On rescind(destination stage)',
			'reset' => 'On reset',
			'accepted_not_completed' => 'Reminder to complete',
			'manual_reminder'=>'Manual reminder',
			),
		'arrow_begin_with' => 'Top',
		'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
		'multiple_child' => true, // flag to set the stage allow multiple childs or not
		'permission' => array(
			'rescind',
			'reset',
			'notifications'
		),
		'assignment_tabs' => false,//only for article assignment
		'enable_casrai_credits_confirm' => false,
		'enable_orcid_confirm' => false,
		'more_reviewers' => false,
		'stage_for' => 'review',
	),
	'decision_resubmit' => array(
		'label' => 'Decision Re-submit',
		'internal_statges' => array(
			'decision_resubmit' => 'Confirm Resubmission'
		),
		'roles' => array(
			'staff'),
		'child_stages' => array(
			'resubmission'),
		'email_templates' => array(
		),
		'possible_email_tmpl_actions' => array(
			'initialization' => 'On stage initialization',
			'assigned' => 'On assignment/invitation',
			'unassign_user' => 'Unassign user',
			//'uninvite_user' => 'Uninvite user',
			'completed' => 'On complete',
			'rescind_source' => 'On rescind(dource stage)',
			'rescind_destination' => 'On rescind(destination stage)',
			'reset' => 'On reset',
			'accepted_not_completed' => 'Reminder to complete',
			'manual_reminder'=>'Manual reminder',
			),
		'default_assignment_type' => 'auto',
		'assignment_options' => array(
			'auto'),
		'generic_form' => false,
		'multiple_child' => false, // flag to set the stage allow multiple childs or not
		'permission' => array(
			'rescind',
			'reset',
			'notifications'
		),
		'assignment_tabs' => true,//only for article assignment
		'enable_casrai_credits_confirm' => false,
		'enable_orcid_confirm' => false,
		'more_reviewers' => false,
		'stage_for' => 'review',
	),
	'resubmission' => array(
		'label' => 'Revision',
		'assignment_tabs' => true,//only for article assignment
		'internal_statges' => array(
			'resubmission_requested' => 'Revision Requested',
			'payment_request_sent' => 'Revision in Progress',
		),
		'roles' => array(
			'author'),
		'child_stages' => array(
			'staff_check',
			'pre_assessment',
			'post_assessment',
							'review'),
		'email_templates' => array(
//					'article_tags',
//					'author_tags',
		),
		'possible_email_tmpl_actions' => array(
			'initialization' => 'On stage initialization', // bcoz start resubmission work as checkout
			'completed' => 'On complete',
			'rescind_source' => 'On rescind(source stage)',
			'rescind_destination' => 'On rescind(destination stage)',
			'reset' => 'On reset',
			'assigned_not_accepted' => 'Reminder to accept',
			'accepted_not_completed' => 'Reminder to complete',
			'manual_reminder'=>'Manual reminder',
			),
		'arrow_begin_with' => 'Top',
		'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
		'multiple_child' => false, // flag to set the stage allow multiple childs or not
		'permission' => array(
			'rescind',
			'reset',
		),
		'enable_casrai_credits_confirm' => false,
		'enable_orcid_confirm' => false,
		'more_reviewers' => false,
		'stage_for' => 'review',
	),
	'copyright' => array(
		'label' => 'Copyright',
		'assignment_tabs' => true,//only for article assignment
		'internal_statges' => array(
			'copyright' => 'Copyright',
		),
		'roles' => array(
			'author'),
		'child_stages' => array(
			'license_check'
		),
		'email_templates' => array(
//					'article_tags',
//					'author_tags',
			'copyright_tags',
		),
		'possible_email_tmpl_actions' => array(
			'assigned' => 'On stage initialization',
			'completed' => 'On complete',
			'rescind_source' => 'On rescind(source stage)',
			'rescind_destination' => 'On rescind(destination stage)',
			'reset' => 'On reset',
			'accepted_not_completed' => 'Reminder to complete',
			'manual_reminder'=>'Manual reminder',
			),
		'static_forms' => array(
			'copyright'
		),
		'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
		'multiple_child' => false, // flag to set the stage allow multiple childs or not
		'permission' => array(
			'rescind',
			'reset',
		),
		'enable_casrai_credits_confirm' => false,
		'enable_orcid_confirm' => false,
		'more_reviewers' => false,
		'stage_for' => 'review',
	),
	'license_check' => array(
		'label' => 'License Check',
		'internal_statges' => array(
			'license_check' => 'License Check',
		),
		'roles' => array(
			'staff','editor_in_chief','associate_editor'),
		'child_stages' => array(
			'payment',
			'production'
		),
		'email_templates' => array(
//					'article_tags',
//					'author_tags',
			'copyright_tags',
		),
		'possible_email_tmpl_actions' => array(
			'initialization' => 'On stage initialization',
			'assigned' => 'On assignment/invitation',
			'unassign_user' => 'Unassign user',
			//'uninvite_user' => 'Uninvite user',
			'completed' => 'On complete',
			'rescind_source' => 'On rescind(source stage)',
			'rescind_destination' => 'On rescind(destination stage)',
			'reset' => 'On reset',
			'accepted_not_completed' => 'Reminder to complete',
			'manual_reminder'=>'Manual reminder',
			),
		'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
		'multiple_child' => true, // flag to set the stage allow multiple childs or not
		'permission' => array(
			'rescind',
			'reset',
		),
		'assignment_tabs' => true,//only for article assignment
		'enable_casrai_credits_confirm' => false,
		'enable_orcid_confirm' => false,
		'more_reviewers' => false,
		'stage_for' => 'review',
	),
	'payment' => array(
		'label' => 'Payment',
		'assignment_tabs' => true,//only for article assignment
		'internal_statges' => array(
			'payment' => 'Payment',
		),
		'roles' => array(
			'system'),
		'child_stages' => array(
			'production'
		),
		'email_templates' => array(
//					'article_tags',
//					'author_tags',
		),
		'possible_email_tmpl_actions' => array(
			'initialization' => 'On stage initialization',
			'completed' => 'On complete',
			'rescind_source' => 'On rescind(source stage)',
			'rescind_destination' => 'On rescind(destination stage)',
			'reset' => 'On reset',
			'accepted_not_completed' => 'Reminder to complete',
			'manual_reminder'=>'Manual reminder',
			),
		'static_forms' => array(
			'payment'
		),
		'generic_form' => -1, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
		'multiple_child' => false, // flag to set the stage allow multiple childs or not
		'permission' => array(
			'rescind',
			'reset',
		),
		'stage_skip_condition' => array(
			'select' => 'count(*) as cnt',
			'model' => 'Payment_order',
			'field' => 'cnt',
			'condition' => ' == 0',
			'article_id' => 'pmt_ord_art_id'
		),
		'enable_casrai_credits_confirm' => false,
		'enable_orcid_confirm' => false,
		'more_reviewers' => false,
		'stage_for' => 'review',
	),
	'production' => array(
		'label' => 'Production',
		'assignment_tabs' => false,//only for article assignment
		'internal_statges' => array(
			'ready_for_production' => 'Ready for Production',
			'production_in_progress' => 'Article Production in Progress',
		),
		'roles' => array(
			'editor_in_chief',
			'associate_editor',
			'staff'),
		'child_stages' => array(
			'qulity_check',
		),
		'email_templates' => array(
//					'article_tags',
		//	'author_tags',
		),
		'possible_email_tmpl_actions' => array(
			'initialization' => 'On stage initialization',
			'assigned' => 'On assignment/invitation',
			'unassign_user' => 'Unassign user',
			//'uninvite_user' => 'Uninvite user',
			'export' => 'On export',
			'rescind_source' => 'On rescind(source stage)',
			'rescind_destination' => 'On rescind(destination stage)',
			'reset' => 'On reset',
			'manual_reminder'=>'Manual reminder',
			),
		'multiple_child' => false, // flag to set the stage allow multiple childs or not
		'permission' => array(
			'rescind',
			'reset',
		),
		'enable_casrai_credits_confirm' => false,
		'enable_orcid_confirm' => false,
		'more_reviewers' => false,
		'stage_for' => 'review',
	),
	'qulity_check' => array(
		'label' => 'Quality checking',
		'assignment_tabs' => FALSE,//only for article assignment
		'internal_statges' => array(
			'ready_for_qulity_checking' => 'Ready for %stage_name%',
			'qulity_checking_in_progress' => '%stage_name% in Progress'
		),
		'roles' => array(
			'production_manager',
			'tsp',
			'type_setter'
		),
		'child_stages' => array(
			'editorial_amendment',
			'graphic_processing',
			'preprocessing',
			)
		,
		'email_templates' => array(
//					'article_tags',
//					'author_tags',
		),
		'possible_email_tmpl_actions' => array(
			'initialization' => 'On stage initialization',
			'unassign_user' => 'Unassign user',
			'completed' => 'On complete',
			'rescind_source' => 'On rescind(source stage)',
			'rescind_destination' => 'On rescind(destination stage)',
			'reset' => 'On Reset',
			'accepted_not_completed' => 'Reminder to complete',
			'manual_reminder'=>'Manual reminder',
			),
		'multiple_child' => true, 
		'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
		'permission' => array(
			//'rescind',
			'reset',
		),
		'download' => array(
			'production_package' => FALSE,
			'previous_files' => FALSE,
		),
		'upload_type' => 'optional', //there is upload required
		'upload' => array(
			'zip',
			'pdf',
			'jpg',
			'jpeg',
							'tif',
							'tiff',
							'eps',
			'png',
			'doc',
			'docx',
							'xls',
							'xlsx',
							'ppt',
							'pptx'
		),
		'enable_ithenticate' => FALSE,
//			'comments_to_author' => true
		'enable_casrai_credits_confirm' => FALSE,
		'enable_orcid_confirm' => FALSE,
		'more_reviewers' => FALSE,
		'milestone_stage' => FALSE,
		'stage_for' => 'manageproduction',
	),
	'editorial_amendment' => array(
		'label' => 'Editorial amendment',
		'assignment_tabs' => FALSE,//only for article assignment
		'internal_statges' => array(
			'ready_for_editorial_amendment' => 'Ready for %stage_name%',
			'editorial_amendment_in_progress' => '%stage_name% in Progress'
		),
		'roles' => array(
			'editor_in_chief',
			'staff'
		),
		'child_stages' => array(
			'qulity_check',
			'pro_revision'
			)
		,
		'email_templates' => array(
				'article_tags',
				'author_tags',
		),
		'possible_email_tmpl_actions' => array(
			'initialization' => 'On stage initialization',
			'unassign_user' => 'Unassign user',
			'completed' => 'On complete',
			'rescind_source' => 'On rescind(source stage)',
			'rescind_destination' => 'On rescind(destination stage)',
			'reset' => 'On Reset',
			'accepted_not_completed' => 'Reminder to complete',
			'manual_reminder'=>'Manual reminder',
			),
		'multiple_child' => true, 
		'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
		'permission' => array(
			'rescind',
			'reset',
		),
		'download' => array(
			'production_package' => FALSE,
			'previous_files' => FALSE,
		),
		'upload_type' => 'required', //there is upload required
		'upload' => array(
			'zip',
			'pdf',
			'jpeg',
			'jpg',
			'png',
			'doc',
			'docx',
		),
		'enable_ithenticate' => FALSE,
//			'comments_to_author' => true
		'enable_casrai_credits_confirm' => FALSE,
		'enable_orcid_confirm' => FALSE,
		'more_reviewers' => FALSE,
		'milestone_stage' => FALSE,
		'stage_for' => 'manageproduction',
		'show_rview_history' => TRUE,
	),
	'pro_revision' => array(
		'label' => 'Author correction',
		'internal_statges' => array(
			'pro_revision' => 'Revision',
		),
		'roles' => array(
			'author'),
		'child_stages' => array(
			'editorial_amendment'
		),
		'email_templates' => array(
//					'article_tags',
//					'author_tags',
		),
		'possible_email_tmpl_actions' => array(
			'assigned' => 'On stage initialization',
			'completed' => 'On complete',
			'rescind_source' => 'On rescind(source stage)',
			'rescind_destination' => 'On rescind(destination stage)',
			'reset' => 'On reset',
			'accepted_not_completed' => 'Reminder to complete',
			//'confirm_casrai' => 'Confirm Contributorship',
			'confirm_orcid' => 'Connect ORCID',
			'manual_reminder'=>'Manual reminder',
			),
		'arrow_begin_with' => 'Top',
		'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
		'multiple_child' => false, // flag to set the stage allow multiple childs or not
		'disable_criteria' => array(),
		'permission' => array(
			'rescind',
			'reset',
		),
		'download' => array(
			'production_package' => FALSE,
			'previous_files' => FALSE,
		),
		'upload_type' => 'required', //there is upload required
		'upload' => array(
			'zip',
			'pdf',
			'jpeg',
			'jpg',
			'png',
			'doc',
			'docx',
			'tif',
			'tiff',
			'odt',
			'tex',
			'eps',
			'ppt',
			'xls',
			'xlsx',
			'bst',
			'cls',
			'bib',
			'pptx',
			'gif',
			'mov',
		),
		'assignment_tabs' => false,//only for article assignment
		'enable_casrai_credits_confirm' => false,
		'enable_orcid_confirm' => false,
		'more_reviewers' => false,
		'stage_for' => 'manageproduction',
		'show_rview_history' => FALSE,
	),
	'editorial_process' => array(
		'label' => 'Editorial process',
		'assignment_tabs' => false,//only for article assignment
		'internal_statges' => array(
			'ready_for_editorial_process' => 'Ready for %stage_name%',
			'editorial_process_in_progress' => '%stage_name% in Progress'
		),
		'roles' => array(
			'type_setter',
			'production_manager',
			'tsp',
			'editor_in_chief',
			'staff'
		),
		'child_stages' => array(
			'preprocessing',
			'copy_editing',
			'type_setting',
			'graphic_processing',
			'postprocessing',
			'aop_publish'
		),
		'email_templates' => array(
//					'article_tags',
//					'author_tags',
		),
		'possible_email_tmpl_actions' => array(
			'initialization' => 'On stage initialization',
			'assigned' => 'On assignment/invitation',
			'unassign_user' => 'Unassign user',
			'completed' => 'On complete',
			'rescind_source' => 'On rescind(source stage)',
			'rescind_destination' => 'On rescind(destination stage)',
			'reset' => 'On Reset',
			'accepted_not_completed' => 'Reminder to complete',
			'manual_reminder'=>'Manual reminder',
			),
		'multiple_child' => true, 
		'default_assignment_type' => 'self_service',
		'assignment_options' => array(
			'self_service',
			//'invitation',
			'manual'),
		'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
		'permission' => array(
			'rescind',
			'reset',
		),
		'download' => array(
			'production_package' => FALSE,
			'previous_files' => FALSE,
		),
		'upload_type' => 'required', //there is upload required
		'upload' => array(
			'zip',
			'pdf',
			'doc',
			'docx',
			'jpg',
			'jpeg',
							'tif',
							'tiff',
			'png',
		),
		'enable_ithenticate' => FALSE,
//			'comments_to_author' => true
		'enable_casrai_credits_confirm' => FALSE,
		'enable_orcid_confirm' => FALSE,
		'more_reviewers' => FALSE,
		'milestone_stage' => FALSE,
		'stage_for' => 'manageproduction',
	),
	'preprocessing' => array(
		'label' => 'Preprocessing',
		'assignment_tabs' => false,//only for article assignment
		'internal_statges' => array(
			'ready_for_preprocessing' => 'Ready for %stage_name%',
			'preprocessing_in_progress' => '%stage_name% in Progress'
		),
		'roles' => array(
			'production_manager',
			'type_setter',
		),
		'child_stages' => array(
			'aop_publish',
			'preprocessing',
			'editorial_process',
			'copy_editing',
			'type_setting',
			)
		,
		'email_templates' => array(
//					'article_tags',
//					'author_tags',
		),
		'possible_email_tmpl_actions' => array(
			'initialization' => 'On stage initialization',
			'assigned' => 'On assignment/invitation',
			'unassign_user' => 'Unassign user',
			'completed' => 'On complete',
			'rescind_source' => 'On rescind(source stage)',
			'rescind_destination' => 'On rescind(destination stage)',
			'reset' => 'On Reset',
			'accepted_not_completed' => 'Reminder to complete',
			'manual_reminder'=>'Manual reminder',
			),
		'multiple_child' => true, 
		'default_assignment_type' => 'self_service',
		'assignment_options' => array(
			'self_service',
			//'invitation',
			'manual'),
		'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
		'permission' => array(
			'rescind',
			'reset',
		),
		'download' => array(
			'production_package' => FALSE,
			'previous_files' => FALSE,
		),
		'upload_type' => 'optional', //there is upload optional
		'upload' => array(
			'zip',
			'pdf',
			'jpeg',
			'jpg',
			'png',
			'doc',
			'docx',
							'indd'
		),
		'list_allstage_files' => TRUE,
		'file_annotate' => TRUE,
		'enable_ithenticate' => FALSE,
//			'comments_to_author' => true
		'enable_casrai_credits_confirm' => FALSE,
		'enable_orcid_confirm' => FALSE,
		'more_reviewers' => FALSE,
		'milestone_stage' => FALSE,
		'stage_for' => 'manageproduction',
	),
	'aop_publish' => array(
		'label' => 'AoP Publish',
		'assignment_tabs' => false,//only for article assignment
		'internal_statges' => array(
			'ready_for_aop_publish' => 'Ready for %stage_name%',
			'aop_publish_in_progress' => '%stage_name% in Progress'
		),
		'roles' => array(
			'tsp',
			'production_manager',
			),
//			'static_forms' => array(
//				'transfer_suggestions'
//			),
		'generic_form' => -1, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.' Changed 0 to -1 . Transit stage don't need custom forms
		'child_stages' => array(),
		'email_templates' => array(),
		'download' => array(
			'production_package' => FALSE,
			'previous_files' => FALSE,
		),
		'list_allstage_files' => TRUE,
		'file_annotate' => TRUE,
		'possible_email_tmpl_actions' => array(
			'completed' => 'On complete',
			'accepted_not_completed' => 'Reminder to complete',
			'manual_reminder'=>'Manual reminder',
			),
		'multiple_child' => false, // flag to set the stage allow multiple childs or not
		'permission' => array(
			'rescind',
			'reset',
		),
		'enable_casrai_credits_confirm' => false,
		'enable_orcid_confirm' => false,
		'more_reviewers' => false,
		'milestone_stage' => TRUE,
		'stage_for' => 'manageproduction',
	),
	'graphic_processing' => array(
		'label' => 'Graphic processing',
		'assignment_tabs' => false,//only for article assignment
		'internal_statges' => array(
			'ready_for_graphic_processing' => 'Ready for %stage_name%',
			'graphic_processing_in_progress' => '%stage_name% in Progress'
		),
		'roles' => array(
			'production_manager',
			'tsp',
			'type_setter'
		),
		'child_stages' => array(
			'editorial_process',
		),
		'email_templates' => array(
//					'article_tags',
//					'author_tags',
		),
		'possible_email_tmpl_actions' => array(
			'initialization' => 'On stage initialization',
			'assigned' => 'On assignment/invitation',
			'unassign_user' => 'Unassign user',
			'completed' => 'On complete',
			'rescind_source' => 'On rescind(source stage)',
			'rescind_destination' => 'On rescind(destination stage)',
			'reset' => 'On Reset',
			'accepted_not_completed' => 'Reminder to complete',
			'manual_reminder'=>'Manual reminder',
			),
		'multiple_child' => true, 
		'default_assignment_type' => 'self_service',
		'assignment_options' => array(
			'self_service',
			//'invitation',
			'manual'),
		'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
		'permission' => array(
			'rescind',
			'reset',
		),
		'download' => array(
			'production_package' => FALSE,
			'previous_files' => FALSE,
		),
		'upload_type' => 'required', //there is upload required
		'upload' => array(
			'zip',
			'pdf',
			'jpeg',
			'jpg',
			'png',
			'doc',
			'docx',
			'ai',
			'eps',
							'cdr'
		),
		'enable_ithenticate' => FALSE,
//			'comments_to_author' => true
		'enable_casrai_credits_confirm' => FALSE,
		'enable_orcid_confirm' => FALSE,
		'more_reviewers' => FALSE,
		'milestone_stage' => FALSE,
		'stage_for' => 'manageproduction',
	),
	'copy_editing' => array(
		'label' => 'Copyediting',
		'assignment_tabs' => false,
		'internal_statges' => array(
			'ready_for_copy_editing' => 'Ready for %stage_name%',
			'copy_editing_in_progress' => '%stage_name% in Progress'
		),
		'roles' => array(
			'copy_editor',
		),
		'child_stages' => array(
			'type_setting'
		),
		'email_templates' => array(
//					'article_tags',
//					'author_tags',
		),
		'possible_email_tmpl_actions' => array(
			'initialization' => 'On stage initialization',
			'assigned' => 'On assignment/invitation',
			'unassign_user' => 'Unassign user',
			'completed' => 'On complete',
			'rescind_source' => 'On rescind(source stage)',
			'rescind_destination' => 'On rescind(destination stage)',
			'reset' => 'On Reset',
			'accepted_not_completed' => 'Reminder to complete',
			'manual_reminder'=>'Manual reminder',
			),
		'multiple_child' => true,
		'default_assignment_type' => 'self_service',
		'assignment_options' => array(
			'self_service',
			//'invitation',
			'manual'),
		'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
		'permission' => array(
			'rescind',
			'reset',
		),
		'download' => array(
			'production_package' => FALSE,
			'previous_files' => FALSE,
		),
		'upload_type' => 'required', //there is upload required
		'upload' => array(
			'zip',
			'pdf',
			'doc',
			'docx',
							'tif',
							'tiff',
							'jpg',
							'jpeg',
		),
		'enable_ithenticate' => FALSE,
//			'comments_to_author' => true
		'enable_casrai_credits_confirm' => FALSE,
		'enable_orcid_confirm' => FALSE,
		'more_reviewers' => FALSE,
		'milestone_stage' => FALSE,
		'stage_for' => 'manageproduction',
	),
	'type_setting' => array(
		'label' => 'Typesetting',
		'assignment_tabs' => false,
		'internal_statges' => array(
			'ready_for_type_setting' => 'Ready for %stage_name%',
			'type_setting_in_progress' => '%stage_name% in Progress'
		),
		'roles' => array(
			'type_setter',
		),
		'child_stages' => array(
			'proof_reading',
			'copy_editing',
			'postprocessing',
		),
		'email_templates' => array(
//					'article_tags',
//					'author_tags',
		),
		'possible_email_tmpl_actions' => array(
			'initialization' => 'On stage initialization',
			'assigned' => 'On assignment/invitation',
			'unassign_user' => 'Unassign user',
			'completed' => 'On complete',
			'rescind_source' => 'On rescind(source stage)',
			'rescind_destination' => 'On rescind(destination stage)',
			'reset' => 'On Reset',
			'accepted_not_completed' => 'Reminder to complete',
			'manual_reminder'=>'Manual reminder',
			),
		'multiple_child' => true, 
		'default_assignment_type' => 'self_service',
		'assignment_options' => array(
			'self_service',
			//'invitation',
			'manual'),
		'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
		'permission' => array(
			'rescind',
			'reset',
		),
		'download' => array(
			'production_package' => FALSE,
			'previous_files' => FALSE,
		),
		'upload_type' => 'required', //there is upload required
		'upload' => array(
			'zip',
			'pdf',
							'indd',
			'doc',
			'docx',
		),
		'list_allstage_files' => TRUE,
		'file_annotate' => TRUE,
//			'static_forms' => array(
//				'type_setting'
//			),
		'enable_ithenticate' => FALSE,
//			'comments_to_author' => true
		'enable_casrai_credits_confirm' => FALSE,
		'enable_orcid_confirm' => FALSE,
		'more_reviewers' => FALSE,
		'milestone_stage' => FALSE,
		'stage_for' => 'manageproduction',
	),
	'proof_reading' => array(
		'label' => 'Proofreading',
		'assignment_tabs' => false,
		'internal_statges' => array(
			'ready_for_proof_reading' => 'Ready for %stage_name%',
			'proof_reading_in_progress' => '%stage_name% in Progress'
		),
		'roles' => array(
			'author',
			'proof_reader',
			'staff',
			'production_manager',
			'tsp',
			'editor_in_chief'
		),
		'child_stages' => array(
			'editorial_process',
			'postprocessing',
			'proof_reading',
		),
		'email_templates' => array(
//					'article_tags',
//					'author_tags',
		),
		'possible_email_tmpl_actions' => array(
			'initialization' => 'On stage initialization',
			'assigned' => 'On assignment/invitation',
			'unassign_user' => 'Unassign user',
			'completed' => 'On complete',
			'rescind_source' => 'On rescind(source stage)',
			'rescind_destination' => 'On rescind(destination stage)',
			'reset' => 'On Reset',
			'accepted_not_completed' => 'Reminder to complete',
			'manual_reminder'=>'Manual reminder',
			),
		'multiple_child' => true, 
		'default_assignment_type' => 'self_service',
		'assignment_options' => array(
			'self_service',
			//'invitation',
			'manual'),
		'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
		'permission' => array(
			'rescind',
			'reset',
		),
		'download' => array(
			'production_package' => FALSE,
			'previous_files' => FALSE,
		),
		'upload_type' => 'optional', //there is may /may not upload
		'upload' => array(
			'zip',
			'pdf',
			'doc',
			'docx',
		),
//			'static_forms' => array(
//				'proof_reading'
//			),
		'enable_ithenticate' => FALSE,
//			'comments_to_author' => true
		'enable_casrai_credits_confirm' => FALSE,
		'enable_orcid_confirm' => FALSE,
		'more_reviewers' => FALSE,
		'milestone_stage' => FALSE,
		'stage_for' => 'manageproduction',
	),
	/*'editorial_manage' => array(
		'label' => 'Production Management',
		'assignment_tabs' => FALSE,
		'internal_statges' => array(
			'ready_for_editorial_manage' => 'Ready for %stage_name%',
			'editorial_manage_in_progress' => '%stage_name% in Progress'
		),
		'roles' => array(
			'production_manager',
		),
		'child_stages' => array(
			'publish',
			'proof_reading',
			'type_setting',
			'copy_editing',
		),
		'email_templates' => array(
//					'article_tags',
//					'author_tags',
		),
		'possible_email_tmpl_actions' => array(
			'initialization' => 'On stage initialization',
			'assigned' => 'On assignment/invitation',
			'completed' => 'On complete',
			'rescind_source' => 'On rescind(source stage)',
			'rescind_destination' => 'On rescind(destination stage)',
			'reset' => 'On Reset',
			'accepted_not_completed' => 'Reminder to complete',
			'manual_reminder'=>'Manual reminder',
			),
		'multiple_child' => true, 
		'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
		'permission' => array(
			'rescind',
			'reset',
		),
		'download' => array(
			'production_package' => FALSE,
			'previous_files' => TRUE,
		),
		'upload_type' => 'optional', //there is may /may not upload
		'upload' => array(
			'zip',
			'pdf',
			'jpeg',
			'jpg',
			'png',
			'doc',
			'docx',
		),
//			'static_forms' => array(
//				'proof_reading'
//			),
		'enable_ithenticate' => FALSE,
//			'comments_to_author' => true
		'enable_casrai_credits_confirm' => FALSE,
		'enable_orcid_confirm' => FALSE,
		'more_reviewers' => FALSE,
		'stage_for' => 'manageproduction',
	),*/
	'postprocessing' => array(
		'label' => 'Post processing',
		'assignment_tabs' => false,
		'internal_statges' => array(
			'ready_for_postprocessing' => 'Ready for %stage_name%',
			'postprocessing_in_progress' => '%stage_name% in Progress'
		),
		'roles' => array(
			'production_manager',
			'tsp',
			'type_setter'
		),
		'child_stages' => array(
			'publish',
			'postprocessing',
			'editorial_process',
			'proof_reading'
		),
		'email_templates' => array(
//					'article_tags',
//					'author_tags',
		),
		'possible_email_tmpl_actions' => array(
			'initialization' => 'On stage initialization',
			'assigned' => 'On assignment/invitation',
			'unassign_user' => 'Unassign user',
			'completed' => 'On complete',
			'rescind_source' => 'On rescind(source stage)',
			'rescind_destination' => 'On rescind(destination stage)',
			'reset' => 'On Reset',
			'accepted_not_completed' => 'Reminder to complete',
			'manual_reminder'=>'Manual reminder',
			),
		'multiple_child' => true, 
		'default_assignment_type' => 'self_service',
		'assignment_options' => array(
			'self_service',
			//'invitation',
			'manual'),
		'generic_form' => 0, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
		'permission' => array(
			'rescind',
			'reset',
		),
		'download' => array(
			'production_package' => FALSE,
			'previous_files' => FALSE,
		),
		'upload_type' => 'optional', //there is may /may not upload
		'upload' => array(
			'zip',
			'pdf',
			'jpeg',
			'jpg',
			'png',
			'doc',
			'docx',
							'indd'
		),
		'list_allstage_files' => TRUE,
		'file_annotate' => TRUE,
//			'static_forms' => array(
//				'proof_reading'
//			),
		'enable_ithenticate' => FALSE,
//			'comments_to_author' => true
		'enable_casrai_credits_confirm' => FALSE,
		'enable_orcid_confirm' => FALSE,
		'more_reviewers' => FALSE,
		'milestone_stage' => FALSE,
		'stage_for' => 'manageproduction',
	),
	'publish' => array(
		'label' => 'Publish',
		'assignment_tabs' => false,//only for article assignment
		'internal_statges' => array(
			'ready_for_publish' => 'Ready for %stage_name%',
			'publish_in_progress' => '%stage_name% in Progress'
		),
		'roles' => array(
			'production_manager',
			'tsp',
			'type_setter',
		),
		'child_stages' => array()
		,
		'email_templates' => array(
//					'article_tags',
//					'author_tags',
		),
		'possible_email_tmpl_actions' => array(
			'initialization' => 'On stage initialization',
			'assigned' => 'On assignment/invitation',
			'unassign_user' => 'Unassign user',
			'completed' => 'On complete',
			'rescind_source' => 'On rescind(source stage)',
			'rescind_destination' => 'On rescind(destination stage)',
			'reset' => 'On Reset',
			'accepted_not_completed' => 'Reminder to complete',
			'manual_reminder'=>'Manual reminder',
			),
		'multiple_child' => true, 
		'permission' => array(
			'rescind',
			//'reset',
		),
		'generic_form' => -1, // flag to set generic forms required 1 - should have, 0 - can have, -1 should not have.'
		'download' => array(
			'production_package' => FALSE,
			'previous_files' => FALSE,
		),
		'file_annotate' => TRUE,
		//'upload_type' => 'optional', //there is may /may not upload
		'upload' => array(),
		'enable_ithenticate' => FALSE,
//			'comments_to_author' => true
		'enable_casrai_credits_confirm' => FALSE,
		'enable_orcid_confirm' => FALSE,
		'more_reviewers' => FALSE,
		'milestone_stage' => FALSE,
		'stage_for' => 'manageproduction',
	),
);
$config['customdata'] =array(
	'te'=>array(
		'textbox',
		'radiobutton'
	),
	'textarea'=>array(
		'textbox',
		'radiobutton',
		'textarea'
	)
);
return $config;
