<?php

return [
    'article' => [
        'flags_and_labels' => [
            'flag' => [
                'label' => 'Flags',
                'tables' => [
                    [
                        'name' => 'rvw_article_flag',
                        'join' => 'LEFT',
                        'on' => ['rvw_articles.art_id', '=', 'rvw_article_flag.aflg_art_id']
                    ],
                    [
                        'name' => 'rvw_flags',
                        'join' => '',
                        'on' => ['rvw_article_flag.aflg_flag_id', '=', 'rvw_flags.flag_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'contains',
                            'value' => 0
                        ],
                        [
                            'label' => 'not contains',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['rvw_flags.flag_name', '=', '?']],
                        [['rvw_flags.flag_name', '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select distinct flag_id as value,flag_name as label from rvw_flags where flag_name like ? ",
                            'options_from' => ['model' => 'Flags', 'columns' => ['flag_id as value', 'flag_name as label']],
                            'search_value' => true,
                            'component' => "select_box"
                        ]
                    ],
                ]
            ],
            'resub_paper' => [
                'label' => 'Is resubmitted paper',
                'tables' => [],
                'condition' => [
                    'value_type' => null,
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Yes',
                            'value' => 0
                        ],
                        [
                            'label' => 'No',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['rvw_articles.art_prev_article_id', 'is not', null]],
                        [['rvw_articles.art_prev_article_id', 'is', null]]
                    ],
                    'options' => [
                        [
                            'component' => null,
                        ]
                    ]
                ]
            ],
            'is_transfered' => [
                'label' => 'Is transfered paper',
                'tables' => [],
                'condition' => [
                    'value_type' => null,
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Yes',
                            'value' => 0
                        ],
                        [
                            'label' => 'No',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['rvw_articles.art_prev_article_id', 'is not', null], ['rvw_articles.art_transfer_article', '=', 'y']],
                        [['rvw_articles.art_transfer_article', '<>', 'y']]
                    ],
                    'options' => [
                        [
                            'component' => null
                        ]
                    ]
                ]
            ],
            'is_special_issue' => [
                'label' => 'Special issue',
                'tables' => [
                    [
                        'name' => 'rvw_article_types',
                        'join' => 'RIGHT',
                        'on' => ['rvw_articles.art_artp_id', '=', 'rvw_article_types.artp_id']
                    ],
                ],
                'condition' => [
                    'value_type' => null,
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Yes',
                            'value' => 0
                        ],
                        [
                            'label' => 'No',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [[" (rvw_articles.artp_special_issue = 'y' or art_publication_issue is not null or art_publication_issue in (select iss_id fro  rvw_issues where iss_special_issue = 'y')) ", '', 'raw_cdtn']],
                        [[" (rvw_articles.artp_special_issue <> 'y' and (art_publication_issue is null or art_publication_issue not in (select iss_id fro  rvw_issues where iss_special_issue = 'y'))) ", '', 'raw_cdtn']]
                    ],
                    'options' => [
                        [
                            'component' => null
                        ]
                    ]
                ]
            ],
            'biorxiv' => [
                'label' => 'bioRxiv',
                'tables' => [],
                'condition' => [
                    'value_type' => null,
                    'fixed_option' =>
                    [
                        [
                            'label' => 'B2J',
                            'value' => 0
                        ],
                        [
                            'label' => 'J2B',
                            'value' => 1
                        ],
                        [
                            'label' => 'None',
                            'value' => 3
                        ]
                    ],
                    'fixed_value' => [
                        [['rvw_articles.art_biorxiv', 'is not', null], ['rvw_articles.art_biorxiv', '=', 'y']],
                        [['rvw_articles.art_biorxiv', 'is not', null], ['rvw_articles.art_biorxiv', '=', 'b']],
                        [['rvw_articles.art_biorxiv', 'is', null], ['rvw_articles.art_biorxiv', '=', 'n']]
                    ],
                    'options' => [
                        [
                            'component' => null
                        ]
                    ]
                ]
            ]
        ],
        'article' => [
            'article_id' => [
                'label' => 'Article ID',
                'tables' => [],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' => "condition_params",      //to refer condition_params from 'report_generation.php'
                    'fixed_value' => [
                        'type' => 'string',      //referer for condition_params['type']['string'] from 'report_generation.php'
                        'col' => 'rvw_articles.art_code'
                    ],
                    'options' => [
                        [
                            'component' => "text"
                        ]
                    ],
                ]
            ],
            'article_title' => [
                'label' => 'Article Title',
                'tables' => [],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' => "condition_params",      //to refer condition_params from 'report_generation.php'
                    'fixed_value' => [
                        'type' => 'string',      //referer for condition_params['type']['string'] from 'report_generation.php'
                        'col' => 'rvw_articles.art_title'
                    ],
                    'options' => [
                        [
                            'component' => "text"
                        ]
                    ],
                ]
            ],
            'article_keyword' => [
                'label' => 'Keywords',
                'tables' => [
                    [
                        'name' => 'rvw_article_keywords',
                        'join' => '',
                        'on' => ['rvw_articles.art_id', '=', 'rvw_article_keywords.ak_art_id']
                    ],
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'contains',
                            'value' => 0
                        ],
                        [
                            'label' => 'not contains',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['rvw_article_keywords.ak_keyword_id', 'IN', '?']],
                        [['rvw_article_keywords.ak_keyword_id', 'NOT IN', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select kwd_id as value,kwd_name as label from rvw_keywords where kwd_name like ? ",
                            'options_from' => ['model' => 'Keywords', 'columns' => ['kwd_id as value', 'kwd_name as label']],
                            'search_value' => true,
                            'component' => "multi_box"
                        ]
                    ],
                ]
            ],
            'art_pre_all_ids' => [
                'label' => 'Original ID of paper (if resubmitted)',
                'tables' => [
                    [
                        'name' => 'rvw_articles as art_cp',
                        'join' => '',
                        'on' => ['rvw_articles.art_id', '=', "SUBSTRING_INDEX(art_cp.art_pre_all_ids, ',', 1)"]
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' => "condition_params",      //to refer condition_params from 'report_generation.php'
                    'fixed_value' => [
                        'type' => 'string',      //referer for condition_params['type']['string'] from 'report_generation.php'
                        'col' => 'art_cp.art_code'
                    ],
                    'options' => [
                        [
                            'component' => "text"
                        ]
                    ],
                ]
            ]
        ],
        'copyright' => [
            'copyright' => [
                'label' => 'Copyright',
                'tables' => [
                    [
                        'name' => 'rvw_copyright',
                        'join' => '',
                        'on' => ['rvw_articles.art_id', '=', 'rvw_copyright.crt_art_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['rvw_copyright.crt_id', '=', '?']],
                        [['rvw_copyright.crt_id', '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select  crtm_id as value, crtm_license_name as label from rvw_copyright_master",
                            'options_from' => ['model' => 'Copyright_master', 'columns' => ['crtm_id as value', 'crtm_license_name as label']],
                            'search_value' => false,
                            'component' => "select_box"
                        ]
                    ],
                ]
            ],
            'copyright_open' => [
                'label' => 'Copyright',
                'table' => [
                    [
                        'name' => 'rvw_copyright',
                        'join' => '',
                        'on' => ['rvw_articles.art_id', '=', 'rvw_copyright.crt_art_id']
                    ],
                    [
                        'name' => 'rvw_copyright_master',
                        'join' => 'inner',
                        'on' => ['rvw_copyright_master.crtm_id', '=', 'rvw_copyright.crt_crtm_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Yes',
                            'value' => 0
                        ],
                        [
                            'label' => 'No',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['rvw_copyright_master.crtm_payment', '=', 'o']],
                        [['rvw_copyright_master.crtm_payment', '!=', 'o']]
                    ],
                    'options' => [
                        [
                            'component' => null
                        ]
                    ],
                ]
            ]
        ],
        'journal' => [
            'journal' => [
                'label' => 'Journal',
                'tables' => [
                    [
                        'name' => 'rvw_article_types',
                        'join' => 'RIGHT',
                        'on' => ['rvw_articles.art_artp_id', '=',  'rvw_article_types.artp_id']
                    ],
                    [
                        'name' => 'rvw_journals',
                        'join' => 'RIGHT',
                        'on' => ['rvw_article_types.artp_jnl_id', '=', 'rvw_journals.jnl_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['rvw_journals.jnl_id', '=', '?']],
                        [['rvw_journals.jnl_id', '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select jnl_id as value, jnl_journal_name as label from rvw_journals where jnl_journal_name like ? ",
                            'options_from' => ['model' => 'Journals', 'columns' => ['jnl_id as value', 'jnl_journal_name as label']],
                            'search_value' => true,
                            'component' => "select_box"
                        ]
                    ],
                ]
            ],
            'is_standalone' => [
                'label' => 'Is standalone',
                'tables' => [
                    [
                        'name' => 'rvw_article_types',
                        'join' => 'RIGHT',
                        'on' => ['rvw_articles.art_artp_id', '=',  'rvw_article_types.artp_id']
                    ],
                    [
                        'name' => 'rvw_journals',
                        'join' => 'RIGHT',
                        'on' => ['rvw_article_types.artp_jnl_id', '=', 'rvw_journals.jnl_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Yes',
                            'value' => 0
                        ],
                        [
                            'label' => 'No',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['rvw_journals.jnl_id', '=', 'y']],
                        [['rvw_journals.jnl_id', '!=', 'n']]
                    ],
                    'options' => [
                        [
                            'component' => null,
                        ]
                    ],
                ]

            ],
            'article_type' => [
                'label' => 'Submitted article type',
                'tables' => [],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['rvw_articles.art_artp_id', '=', '?']],
                        [['rvw_articles.art_artp_id', '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select artp_id as value, artp_article_type as label, jnl_journal_name as parent from rvw_article_types inner join rvw_journals on artp_jnl_id = jnl_id ",
                            'options_from' => ['model' => 'Article_types', 'columns' => ['artp_id as value', 'artp_article_type as label']],
                            'search_value' => false,
                            'component' => "select_box",
                        ]
                    ],
                ]
            ],
            'published_article_type' => [
                'label' => 'Published article type',
                'tables' => [],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['rvw_articles.art_published_article_type', '=', '?']],
                        [['rvw_articles.art_published_article_type', '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select artp_id as value, artp_article_type as label, jnl_journal_name as parent from rvw_article_types inner join rvw_journals on artp_jnl_id = jnl_id ",
                            'options_from' => ['model' => 'Article_types', 'columns' => ['artp_id as value', 'artp_article_type as label']],
                            'search_value' => false,
                            'component' => "select_box",
                        ]
                    ],
                ]
            ],
            'submitted_published_article_type' => [
                'label' => 'Submitted and Published article types',
                'tables' => [],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Are same',
                            'value' => 0
                        ],
                        [
                            'label' => 'Are different',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['rvw_articles.art_artp_id', '=', 'rvw_articles.art_published_article_type']],
                        [['rvw_articles.art_artp_id', '!=', 'rvw_articles.art_published_article_type']]
                    ],
                    'options' => [
                        [
                            'component' => null,
                        ]
                    ],
                ]
            ],
            'stage_based' => [
                'label' => 'Stage based',
                'tables' => [
                    [
                        'name' => 'rvw_article_flow',
                        'join' => '',
                        'on' => ['rvw_articles.art_id', '=', 'rvw_article_flow.aflw_art_id']
                    ],
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Should be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['rvw_articles.art_artp_id', '=', 'rvw_articles.art_published_article_type']],
                        [['rvw_articles.art_artp_id', '!=', 'rvw_articles.art_published_article_type']]
                    ],
                    'options' => [
                        [
                            'query' => "select jnl_fwm_id as value, jnl_journal_name as label from rvw_journals",
                            'options_from' => ['model' => 'Journals', 'columns' => ['jnl_fwm_id as value', 'jnl_journal_name as label']],
                            'search_value' => false,
                            'component' => "select_box",
                        ],
                        [
                            'query' => "select jwf_id as value, jwf_stage_name as label from rvw_journal_workflows where jwf_fwm_id like ? and jwf_stage_name like ?",
                            'options_from' => ['model' => 'Generic_flows', 'columns' => ['jwf_id as value', 'jwf_stage_name as label']],
                            'search_value' => false,
                            'component' => 'select_box',
                            'dependent' => "0",                     //index of depending option (here this option is depend on 0th option)
                            'type' => 'three'

                        ]
                    ],
                ]
            ],
        ],
        'payments' => [
            'payment_is' => [
                'label' => 'Payment status',
                'tables' => [
                    [
                        'name' => 'rvw_payment_order',
                        'join' => '',
                        'on' => ['rvw_articles.art_id', '=', 'rvw_payment_order.pmt_ord_art_id']
                    ],
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Should be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['rvw_payment_order.pmt_transaction_status', '=', 'rvw_articles.art_published_article_type']],
                        [['rvw_payment_order.pmt_transaction_status', '!=', 'rvw_articles.art_published_article_type']]
                    ],
                    'options' => [
                        [
                            'custom_opt' => [
                                ['label' => 'Finished', 'value' => 'fn'],
                                ['label' => 'Cancelled', 'value' => 'cl'],
                                ['label' => 'Invoice Generated', 'value' => 'cc'],
                            ],
                            'search_value' => false,
                            'component' => 'select_box',
                        ]
                    ],
                ]
            ],
        ],
        'review' => [
            'art_decision' => [
                'label' => 'Decision',
                'tables' => [
                    [
                        'name' => "(SELECT MAX(aflw_id) max_aflw_id, aflw_art_id, rvw_journal_workflows.jwf_stage_type FROM rvw_article_flow JOIN rvw_journal_workflows ON rvw_article_flow.aflw_jwf_id = rvw_journal_workflows.jwf_id WHERE rvw_journal_workflows.jwf_stage_type IN( 'accept', 'reject', 'decision_revision', 'resubmission' ) AND aflw_returned_date IS NOT NULL GROUP BY aflw_art_id) art_flow_last_decision",
                        'join' => 'LEFT',
                        'on' => ['rvw_articles.art_id', '=', 'art_flow_last_decision.aflw_art_id']
                    ],
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Should be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['art_flow_last_decision.jwf_stage_type', '=', '?']],
                        [['art_flow_last_decision.jwf_stage_type', '!=', '?']]
                    ],
                    'options' => [
                        [
                            'custom_opt' => [
                                ['label' => 'Accept', 'value' => 'accept'],
                                ['label' => 'Reject', 'value' => 'reject'],
                                ['label' => 'Revision confirmation', 'value' => 'decision_revision'],
                                ['label' => 'Resubmission', 'value' => 'resubmission'],
                            ],
                            'search_value' => false,
                            'component' => 'select_box',
                        ]
                    ],
                ]
            ],
            'reviewed_by' => [
                'label' => 'Reviewed by',
                'tables' => [
                    [
                        'name' => 'rvw_article_flow as reviewer_article_flow',
                        'join' => '',
                        'on' => ['reviewer_work_flow.aflw_id', '=', 'rvw_articles.art_id']
                    ],
                    [
                        'name' => 'rvw_journal_workflows as reviewer_journal_workflow',
                        'join' => '',
                        'on' => ['reviewer_journal_workflow.jwf_id', '=', 'reviewer_work_flow.aflw_jwf_id']
                    ],
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Should be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['reviewer_article_flow.aflw_status IN (\'c\' , \'a\') ', '', 'raw_cdtn'], ['reviewer_journal_workflow.jwf_stage_type', '=', 'review'], ['reviewer_article_flow.aflw_usr_id', '=', '?']],
                        [['reviewer_article_flow.aflw_status IN (\'c\' , \'a\') ', '', 'raw_cdtn'], ['reviewer_journal_workflow.jwf_stage_type', '=', 'review'], ['reviewer_article_flow.aflw_usr_id', '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) as label, usr_id as value from rvw_users where concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) like ?",
                            'options_from' => ['model' => 'User', 'columns' => ['usr_id as value', "concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) as label"]],
                            'search_value' => true,
                            'component' => "select_box",
                        ]
                    ],
                ]
            ],
            'reviewed_declined_by' => [
                'label' => 'Reviewed declined by',
                'tables' => [
                    [
                        'name' => 'rvw_article_flow as reviewer_article_flow',
                        'join' => '',
                        'on' => ['reviewer_work_flow.aflw_id', '=', 'rvw_articles.art_id']
                    ],
                    [
                        'name' => 'rvw_journal_workflows as reviewer_journal_workflow',
                        'join' => '',
                        'on' => ['reviewer_journal_workflow.jwf_id', '=', 'reviewer_work_flow.aflw_jwf_id']
                    ],
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Should be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['reviewer_article_flow.aflw_status', '=', 'd'], ['reviewer_journal_workflow.jwf_stage_type', '=', 'review'], ['reviewer_article_flow.aflw_usr_id', '=', '?']],
                        [['reviewer_article_flow.aflw_status', '=', 'd'], ['reviewer_journal_workflow.jwf_stage_type', '=', 'review'], ['reviewer_article_flow.aflw_usr_id', '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) as label, usr_id as value from rvw_users where concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) like ?",
                            'options_from' => ['model' => 'User', 'columns' => ['usr_id as value', "concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) as label"]],
                            'search_value' => true,
                            'component' => "select_box",
                        ]
                    ],
                ]
            ],
            'presently_reviewed_by' => [
                'label' => 'Being reviewed by',
                'tables' => [
                    [
                        'name' => 'rvw_article_flow as reviewer_article_flow',
                        'join' => '',
                        'on' => ['reviewer_work_flow.aflw_id', '=', 'rvw_articles.art_id']
                    ],
                    [
                        'name' => 'rvw_journal_workflows as reviewer_journal_workflow',
                        'join' => '',
                        'on' => ['reviewer_journal_workflow.jwf_id', '=', 'reviewer_work_flow.aflw_jwf_id']
                    ],
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Should be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['reviewer_article_flow.aflw_status', '=', 'a'], ['reviewer_journal_workflow.jwf_stage_type', '=', 'review'], ['reviewer_article_flow.aflw_usr_id', '=', '?']],
                        [['reviewer_article_flow.aflw_status', '=', 'a'], ['reviewer_journal_workflow.jwf_stage_type', '=', 'review'], ['reviewer_article_flow.aflw_usr_id', '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) as label, usr_id as value from rvw_users where concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) like ?",
                            'options_from' => ['model' => 'User', 'columns' => ['usr_id as value', "concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) as label"]],
                            'search_value' => true,
                            'component' => "select_box",
                        ]
                    ],
                ]
            ],
            'reviewed_by_and_days' => [
                'label' => 'Reviews and days passed',
                'tables' => [
                    [
                        'name' => 'rvw_article_flow as reviewer_article_flow',
                        'join' => '',
                        'on' => ['reviewer_work_flow.aflw_id', '=', 'rvw_articles.art_id']
                    ],
                    [
                        'name' => 'rvw_journal_workflows as reviewer_journal_workflow',
                        'join' => '',
                        'on' => ['reviewer_journal_workflow.jwf_id', '=', 'reviewer_work_flow.aflw_jwf_id']
                    ],
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Should be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['reviewer_article_flow.aflw_status', '=', 'c'], ['reviewer_journal_workflow.jwf_stage_type', '=', 'review'], ['reviewer_article_flow.aflw_usr_id', '=', '?']],
                        [['reviewer_article_flow.aflw_status', '=', 'c'], ['reviewer_journal_workflow.jwf_stage_type', '=', 'review'], ['reviewer_article_flow.aflw_usr_id', '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) as label, usr_id as value from rvw_users where concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) like ?",
                            'options_from' => ['model' => 'User', 'columns' => ['usr_id as value', "concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) as label"]],
                            'search_value' => true,
                            'component' => "select_box",
                        ],
                        [
                            'query' => "select concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) as label, usr_id as value from rvw_users where concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) like ?",
                            'options_from' => ['model' => 'User', 'columns' => ['usr_id as value', "concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) as label"]],
                            'search_value' => true,
                            'component' => "select_box",
                        ]
                    ],
                ]
            ],
        ]
    ]
];
